Bartender3 = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")

Bartender3.version = "3.0." .. string.sub("$Revision: 19340 $", 12, -3)
Bartender3.date = string.sub("$Date: 2006-12-06 08:43:18 -0500 (Wed, 06 Dec 2006) $", 8, 17)
Bartender3.hasIcon = "Interface\\Icons\\INV_Drink_05"
Bartender3.hasNoColor = true
Bartender3.defaultMinimapPosition = 285
Bartender3.clickableTooltip = false
Bartender3.hideWithoutStandby = true
Bartender3.independentProfile = true
Bartender3.cannotDetachTooltip = true

local dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Bartender3")

function Bartender3:OnInitialize()
	self:RegisterDB("BT3DB")
	
	_, self.playerclass = UnitClass("player")
	
	self:SetupDefaults()
	self:PopulateOptions()
	
	self.unlock = false
	self.actionbars, self.actionbuttons, self.specialbars, self.bars = {}, {}, {}, {}
	for i=1,120 do
		self.actionbuttons[i] = { state = "unused", object = nil}
	end

	for i=1,10 do
		if self.db.profile.Bars[i].Enabled then
			local bar = Bartender3.Class.ActionBar:new(i, self.db.profile.Bars[i], self.db.profile.Bars[i].Buttons or 12)
			self.actionbars[i] = bar
		else
			-- feed a dummy config entry into the options table, so that we can actually activate it.
			self:CreateDisabledBarOptions(i)
		end
	end
	
	self:RemoveDefaultUIElements()
end

function Bartender3:RemoveDefaultUIElements()
	-- Hide the main grafics
	MainMenuBarArtFrame:Hide()
	MainMenuBar:Hide()
	
	self.specialbars["STANCE"] = 	Bartender3.Class.SpecialBar:new("STANCE", "StanceBar", self.db.profile.SpecialBars["STANCE"])
	self.specialbars["PET"] = 		Bartender3.Class.SpecialBar:new("PET", "PetBar", self.db.profile.SpecialBars["PET"])
	self.specialbars["MICROMENU"] =	Bartender3.Class.SpecialBar:new("MICROMENU", "MicroMenu", self.db.profile.SpecialBars["MICROMENU"])
	self.specialbars["BAGS"] =		Bartender3.Class.SpecialBar:new("BAGS", "BagBar", self.db.profile.SpecialBars["BAGS"])
end

function Bartender3:OnEnable()
	self:RefreshBars()
	self:RefreshKeybindings()
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "CombatLockdown")
end

function Bartender3:OnProfileEnable()
	for i,v in pairs(self.bars) do
		if v.config.Enabled then v:ChangeProfile(self.db.profile.Bars[i]) end
	end
end

function Bartender3:CombatLockdown()
	if self.unlock then
		self:LockBars()
		self:Print("ActionBars have been locked because you entered combat.")
		-- close any dewdrop menu owned by us
		local parent = dewdrop:GetOpenedParent()
		for i,v in pairs(self.bars) do
			if parent == v.frame then
				dewdrop:Close()
			end
		end
	end
end

function Bartender3:GetFreeButton(bar)
	if bar then
		for i=1,12 do
			local button = ((bar.id-1)*12)+i
			if ( self.actionbuttons[button].state == "unused" ) then 
				local newbutton = Bartender3.Class.Button:new(bar, button)
				self.actionbuttons[button].state = "used"
				self.actionbuttons[button].object = newbutton
				return newbutton
			elseif ( self.actionbuttons[button].state == "free" ) then 
				self.actionbuttons[button].state = "used"
				self.actionbuttons[button].object:AssignButton(bar, button)
				return self.actionbuttons[button].object
			end
		end
	end
end

function Bartender3:UnlockBars()
	for i,v in pairs(self.bars) do
		if v.config.Enabled then v:UnlockFrames() end
	end
	self.unlock = true
	self:UpdateDisplay()
end

function Bartender3:LockBars()
	for i,v in pairs(self.bars) do
		if v.config.Enabled then v:LockFrames() end
	end
	self.unlock = nil
	self:UpdateDisplay()
end

function Bartender3:RefreshBars(bar)
	if bar then bar:RefreshLayout() else
		for i,v in pairs(self.bars) do
			if v.config.Enabled then v:RefreshLayout() end
		end
	end
end

function Bartender3:GetConfig(index, special)
	if special then
		return self.db.profile.SpecialBars[index]
	else
		return self.db.profile.Bars[index]
	end
end

function Bartender3:GetBarObject(index, special)
	if special then
		return self.specialbars[index]
	else
		return self.actionbars[index]
	end
end

function Bartender3:SetZoom(zoom)
	self.db.profile.Zoomed = zoom
	for i,v in pairs(self.bars) do
		if v.config.Enabled then v:ButtonZoomCheck() end
	end
end

function Bartender3:SwitchSelfCastModifier(scm)
	local oldscm = self.db.profile.SelfCastModifier
	self.db.profile.SelfCastModifier = scm
	for i,v in pairs(self.actionbars) do
		if v then v:UpdateSelfCast(oldscm) end
	end
end

function Bartender3:ToggleBarEnabled(barid)
	if InCombatLockdown() then return end
	
	local bar, barconfig = self.actionbars[barid], self.db.profile.Bars[barid]
	if bar and barconfig.Enabled then -- disable the bar
		barconfig.Enabled = false
		bar:LockFrames()
		bar.frame:Hide()
		self:CreateDisabledBarOptions(barid)
	elseif bar then -- bar was disabled before
		barconfig.Enabled = true
		bar:InitOptions()
		bar:ChangeProfile(barconfig) -- refresh config
		if self.unlock then bar:UnlockFrames() end
	else -- bar doesnt exist yet
		barconfig.Enabled = true
		bar = Bartender3.Class.ActionBar:new(barid, barconfig, barconfig.Buttons or 12, false)
		self.actionbars[barid] = bar
		if self.unlock then bar:UnlockFrames() end
		self:RefreshKeybindings()
	end
end

function Bartender3:RefreshKeybindings()
	for k, v in pairs(self.db.profile.Keybindings) do
		if v then
			self:RegisterBinding(v, getglobal(k))
		end
	end
end

-- Binding functions basicly from ClosetGnome by rabbit
function Bartender3:ClearBinding(button)
	if not button then return end
	local oldbind = self.db.profile.Keybindings[button:GetName()]
	if not oldbind then return end
	self.db.profile.Keybindings[button:GetName()] = nil
	
	self:Print(string.format("Removing keybinding %s from button %s", oldbind, button.class.id))
	
	SetBinding(oldbind)
end

function Bartender3:RegisterBinding(key, button)
	if not key or not button then return end
	if not AceLibrary("AceConsole-2.0").keybindingValidateFunc(key) then
		self:Print(string.format("%s is not a valid keybinding.", "|cffd9d919"..key.."|r"))
		return
	end
	local buttonName = button:GetName()
	local shouldPrint = true
	for k, v in pairs(self.db.profile.Keybindings) do
		if v == key and k ~= buttonName then
			self.db.profile.Keybindings[k] = nil
		elseif v == key and k == buttonName then
			shouldPrint = false
		elseif k == buttonName and v ~= key then
			-- commented to allow two bindings on one button
			--SetBinding(key) -- remove old binding
		end
	end
	if shouldPrint then 
		self:Print(string.format("Registering keybinding %s to button %s.", "|cffd9d919"..key.."|r", "|cffd9d919 "..button.class.id.."|r")) 
	end
	self.db.profile.Keybindings[buttonName] = key
	-- clear any override bindings
	ClearOverrideBindings(button)
	SetBindingClick(key, buttonName)
end

local Tablet = AceLibrary("Tablet-2.0")
-- FuBar Stuff
function Bartender3:OnTooltipUpdate()
	local cat = Tablet:AddCategory("columns", 2)
	cat:AddLine("text", "Button lock", "text2", self:GetOnOffText(self.db.profile.ButtonLock))
	cat:AddLine("text", "Bar lock", "text2", self:GetOnOffText(not self.unlock))
	Tablet:SetHint("|cffeda55fClick|r to toggle button lock. |cffeda55fShift-Click|r to toggle bar lock.")
end

function Bartender3:GetOnOffText(bool)
	return bool and "|cff00ff00On|r" or "|cffff0000Off|r"
end

function Bartender3:OnClick(button)
	if IsShiftKeyDown() then
		if Bartender3.unlock then
			self:LockBars()
		else
			self:UnlockBars()
		end
	else
		self:LockButtons()
	end
	self:UpdateDisplay()
end

function Bartender3:LockButtons(silence)
	if self.db.profile.ButtonLock then
		self.db.profile.ButtonLock = false
		if not silence then self:Print("ActionBar lock |cffffffcf[|r|cffff0000Off|cffffffcf]|r") end
	else
		self.db.profile.ButtonLock = true
		if not silence then self:Print("ActionBar lock |cffffffcf[|r|cff00ff00On|cffffffcf]|r") end
	end
end

