local dewdrop = AceLibrary("Dewdrop-2.0")

local L = AceLibrary("AceLocale-2.2"):new("Bartender3")

function Bartender3:PopulateOptions()
	self.options = {
		type = "group",
		args = {
			lock = {
				order = 1,
				name = "Lock", 
				type = "toggle",
				desc = "Toggle the lock of the action bars.",
				get = function() return not Bartender3.unlock end,
				set = function(v)
					if Bartender3.unlock then
						Bartender3:LockBars()
					else
						Bartender3:UnlockBars()
					end
				end,
				disabled = function() return InCombatLockdown() end,
			},
			buttonlock = {
				order = 2,
				name = "Lock Buttons", 
				type = "toggle",
				desc = "Toggle the lock of the buttons.",
				get = function() return Bartender3.db.profile.ButtonLock end,
				set = function() Bartender3:LockButtons(true) end,
			},
			tooltip = {
				order = 4,
				name = "Button Tooltip",
				type = "toggle",
				desc = "Toggle the Button Tooltip",
				get = function() return not Bartender3.db.profile.HideTooltip end,
				set = function(h)
					Bartender3.db.profile.HideTooltip = not h
				end,
			},
			selfcast = {
				order = 5,
				name = "Self Casting",
				desc = "Configute Self Casting options",
				type = "group",
				args = {
					modifier = {
						order = 1,
						name = "Modifier SelfCast",
						desc = "SelfCast using CTRL/ALT/SHIFT",
						type = "text",
						get = function() return Bartender3.db.profile.SelfCastModifier end,
						set = function(scm)
							Bartender3:SwitchSelfCastModifier(scm)
						end,
						validate = {"ctrl", "alt", "shift", "none"},
					},
					rightclick = {
						order = 2,
						name = "RightClick SelfCast",
						desc = "SelfCast using Right click",
						type = "toggle",
						get = function() return Bartender3.db.profile.SelfCastRightClick end,
						set = function(v)
							Bartender3.db.profile.SelfCastRightClick = v
							for i,v in pairs(Bartender3.actionbars) do
								if v then v:UpdateSelfCast() end
							end
						end,
					},
				},
				disabled = function() return InCombatLockdown() end,
			},
			cooldown = {
				order = 6,
				name = "Cooldown Count",
				desc = "Toggle the Cooldown Count",
				type = "toggle",
				get = function() return Bartender3.db.profile.ShowCooldown end,
				set = function(sc) 
					Bartender3.db.profile.ShowCooldown = sc 
					for i,v in pairs(Bartender3.actionbars) do
						if v and v.config.Enabled then
							for k,b in pairs(v.buttonobjects) do
								b:UpdateCooldown()
							end
						end
					end
				end,
			},
		},
	}
	
	self:RegisterChatCommand({ "/bar", "/bartender3", "/bt3" }, self.options )
	self.OnMenuRequest = self.options
	self.options.args.standby.hidden = true
end

function Bartender3:CreateBarOptions(id, name, special)
	local optionname = ( special ) and (string.lower(id).."bar") or ("bar"..id)
	
	local order = ( special ) and 50 or (30+id)
	-- Options for all bartypes
	self.options.args[optionname] = {
		order = order, 
		name = name,
		type = "group",
		desc = "Configuration for "..name,
		args = {
			hide = {
				order = 2,
				name = "Hide",
				type = "toggle",
				desc = "Hide "..name,
				get = function() return self:GetConfig(id, special).Hide end,
				set = function() self:GetBarObject(id, special):ToggleVisibilty() end,
				disabled = function() return InCombatLockdown() or not self:GetConfig(id, special).Enabled end,
			},
			rows = {
				order = 4,
				name = "Rows",
				type = "range",
				desc = "Change the rows of the Bar",
				max = 12, min = 1, step = 1, -- maxbuttons will be adjusted by the bar itself.
				get = function() return self:GetConfig(id, special).Rows end,
				set = function(r) 
					self:GetBarObject(id, special):SetRows(r)
				end,
				disabled = function() return InCombatLockdown() or not self:GetConfig(id, special).Enabled end,
				hidden = function() return not (#self:GetBarObject(id, special).buttons > 1) end,
			},
			padding = {
				order = 5,
				name = "Padding",
				type = "range",
				desc = "Padding of the bar.",
				min = -10, max = 30, step = 1,
				get = function() return self:GetConfig(id, special).Padding end,
				set = function(p)
					self:GetBarObject(id, special):SetPadding(p)
				end,
				disabled = function() return InCombatLockdown() or not self:GetConfig(id, special).Enabled end,
			},
			scale = {
				order = 6,
				name = "Scale",
				type = "range",
				desc = "Scale of the bar.",
				min = .1, max = 5, step = 0.05,
				isPercent = true,
				get = function() return self:GetConfig(id, special).Scale end,
				set = function(s)
					self:GetBarObject(id, special):SetScale(s)
				end,
				disabled = function() return InCombatLockdown() or not self:GetConfig(id, special).Enabled end,
			},
			alpha = {
				order = 7,
				name = "Alpha",
				type = "range",
				desc = "Alpha of the bar.",
				min = .1, max = 1,
				get = function() return self:GetConfig(id, special).Alpha end,
				set = function(a)
					self:GetBarObject(id, special):SetAlpha(a)
				end,
				disabled = function() return not self:GetConfig(id, special).Enabled end,
			},
			style = {
				order = 8,
				name = "Style",
				type = "text",
				desc = "Style of the bar.",
				get = function() return self:GetConfig(id, special).Style end,
				set = function(s)
					self:GetBarObject(id, special):SetStyle(s)
				end,
				validate = {"Default", "Zoomed", "Dreamlayout"},
				disabled = function() return InCombatLockdown() or not self:GetConfig(id, special).Enabled end,
			},
		}
	}
	
	local options = self.options.args[optionname]
	
	-- Options for ActionBars
	if not special then
		options.args.enabled = {
			order = 1,
			name = "Enabled",
			type = "toggle",
			desc = "Enable "..name,
			get = function() return self:GetConfig(id).Enabled end,
			set = function() self:ToggleBarEnabled(id) end,
			disabled = function() return InCombatLockdown() end,
		}
		options.args.showgrid = {
			order = 9,
			name = "Show Grid",
			type = "toggle",
			desc = "Show the grid of the bar even while locked.",
			get = function() return self:GetConfig(id).ShowGrid end,
			set = function(s) self:GetBarObject(id):SetShowGrid(s) end,
			disabled = function() return not self:GetConfig(id).Enabled end,
		}
		options.args.paging = {
			order = 10,
			name = "Button Paging",
			type = "group",
			desc = "Configure the State-Based Button Swapping.",
			args = {
				enabled = {
					order = 1,
					name = "Enabled",
					type = "toggle",
					desc = "Toggle the Paging support.",
					get = function() return self:GetConfig(id).StatesEnabled end,
					set = function(v) 
						self:GetConfig(id).StatesEnabled = v 
						self:GetBarObject(id):RefreshStates()
					end,
				},
				modifier = {
					order = 2,
					name = "Modifier",
					type = "group",
					desc = "Swapping based on Modifiers.",
					args = {},
					disabled = function() return not self:GetConfig(id).StatesEnabled end,
				},
				stance = {
					order = 3,
					name = "Stances",
					type = "group",
					desc = "Swapping based on your Stance.",
					args = {},
					hidden = function() return self.stanceinfo[self.playerclass] == nil end,
					disabled = function() return not self:GetConfig(id).StatesEnabled end,
				},
			},
			disabled = function() return InCombatLockdown() or not self:GetConfig(id).Enabled end,
		}
		for i,m in pairs(self.statemodifiers) do
			options.args.paging.args.modifier.args[m] = {
				name = m,
				type = "range",
				desc = "Configure which bar to switch to when "..m.." is down.",
				min = 0, max = 10, step = 1,
				get = function() return self:GetConfig(id).States[m] or 0 end,
				set = function(b) self:GetBarObject(id):SetModifierState(m, b) end,
			}
		end
		for i,v in pairs(self.stanceinfo[self.playerclass] or {}) do
			options.args.paging.args.stance.args[v.short] = {
				order = i,
				name = v.name,
				type = "range",
				desc = "Configure which bar to switch to in "..v.name.." stance.",
				min = 0, max = 10, step = 1,
				get = function() return self:GetConfig(id).Stances[v.short] end,
				set = function(b) self:GetBarObject(id):SetStancePage(v.short, b) end,
			}
		end
		options.args.buttons = {
			order = 11,
			name = "Buttons",
			type = "range",
			desc = "Configure the number of Buttons.",
			min = 1, max = 12, step = 1,
			get = function() return self:GetConfig(id).Buttons end,
			set = function(a)
				self:GetBarObject(id):SetButtons(a)
			end,
			disabled = function() return InCombatLockdown() or not self:GetConfig(id).Enabled end,
		}
		options.args.keybindings = {
			order = 12,
			name = "Keybindings",
			type = "group",
			desc = "Setup keybindings for "..name,
			args = {},
			disabled = function() return InCombatLockdown() or not self:GetConfig(id).Enabled end,
		}
	else
		if id == "BAGS" then
			options.args.keyring = {
				order = 10,
				name = "Keyring",
				type = "toggle",
				desc = "Toggle the Keyring",
				get = function() return self:GetConfig(id, special).Keyring end,
				set = function()
					self:GetBarObject(id, special):ToggleKeyring()
				end,
				disabled = function() return InCombatLockdown() end,
			}
			options.args.onebag = {
				order = 11,
				name = "OneBag",
				type = "toggle",
				desc = "Toggle the display of onle one Bag Icon",
				get = function() return self:GetConfig(id, special).OneBag end,
				set = function()
					self:GetBarObject(id, special):ToggleOneBag()
				end,
				disabled = function() return InCombatLockdown() end,
			}
		elseif id == "MICROMENU" then
			options.args.rows = nil
			options.args.style = nil
		end
	end
	
	return options
end

function Bartender3:CreateDisabledBarOptions(id)
	local name = "Bar "..id
	local optionname = "bar"..id
	
	self.options.args[optionname] = {
		order = 30+id,
		name = name,
		type = "group",
		desc = "Configuration for "..name,
		args = {
			enabled = {
				order = 1,
				name = "Enabled",
				type = "toggle",
				desc = "Enable "..name,
				get = function() return self:GetConfig(id).Enabled end,
				set = function() self:ToggleBarEnabled(id) end,
				disabled = function() return InCombatLockdown() end,
			},
		},
	}
end
