local AceOO = AceLibrary("AceOO-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local L = AceLibrary("AceLocale-2.2"):new("Bartender3")

Bartender3.stanceinfo = { 
	["WARRIOR"] = {
		{
			short = "battle",
			name = "Battle Stance",
			state = 1,
			defpage = 7,
		},
		{
			short = "def",
			name = "Defensive Stance",
			state = 2,
			defpage = 8,
		},
		{
			short = "berserker",
			name = "Berserker Stance",
			state = 3,
			defpage = 9,
		},
	},
	["DRUID"] = {
		{
			short = "bear",
			name = "Bear Form",
			state = 1,
			defpage = 9,
		},
		{
			short = "prowl",
			name = "Cat Form (Prowling)",
			state = 2,
			defpage = 8,
		},
		{
			short = "cat",
			name = "Cat Form",
			state = 3,
			defpage = 7,
		},
		{
			short = "moontree",
			name = "Moonkin/Tree of Life",
			state = 5,
			defpage = 0,
		},
	},
	["ROGUE"] = {
		{
			short = "stealth",
			name = "Stealth",
			state = 1,
			defpage = 7,
		},
	},
	["PRIEST"] = {
		{
			short = "shadowform",
			name = "Shadowform",
			state = 1,
			defpage = 1,
		},
	}
}

Bartender3.statemodifiers = { "ctrl", "alt", "shift" }

if not Bartender3.Class then Bartender3.Class = {} end
Bartender3.Class.Bar = AceOO.Class("AceEvent-2.0")
Bartender3.Class.ActionBar = AceOO.Class(Bartender3.Class.Bar)
Bartender3.Class.SpecialBar = AceOO.Class(Bartender3.Class.Bar)

function Bartender3.Class.Bar.prototype:init(id, config, statebar)
	Bartender3.Class.Bar.super.prototype.init(self)
	self.id = id
	self.config = config
	self.statebar = statebar
	self.barname = "Bar "..self.id
	
	self:CreateBarFrame()
	
	table.insert(Bartender3.bars, self)
	
end

function Bartender3.Class.Bar.prototype:ChangeProfile(config)
	self.config = config
	self:RefreshLayout()
end

function Bartender3.Class.Bar.prototype:CreateBarFrame()
	local name = "BT3Bar"..self.id
	local class = Bartender3.playerclass
	local frame = CreateFrame("Button", name, UIParent, self.statebar and "SecureStateDriverTemplate")
	if self.statebar then
		local states1, states2 = "0:S01;", "0:S02;"
		if self.config.States == nil then self.config.States = {} end
		-- Setup Stances
		if Bartender3.stanceinfo[class] ~= nil then
			-- stance config is nil and we are bar1, setup default stances.
			if self.config.Stances == nil then self.config.Stances = {} end
			for i,v in pairs(Bartender3.stanceinfo[class]) do 
				if self.config.Stances[v.short] == nil and self.id == 1 and v.defpage > 0 then 
					self.config.Stances[v.short] = v.defpage
				end
				states1 = states1 .. v.state .. ":S" .. v.state .. "1;" 
				states2 = states2 .. v.state .. ":S" .. v.state .. "2;" 
			end
			local form = GetShapeshiftForm(true)
			frame:SetAttribute("statemap-stance", "$input")
			if class == "DRUID" then
				--[[ I set all forms which do not need a special page to state 0, so i can have a cleaner layout there :)
					
					"0" - Caster Form
					"1" - Bear Form
					"2" - Cat Form (prowling)
					"3" - Cat Form (not prowling)
					
					All other states are unused and free for later usage
				]]
				frame:SetAttribute("statemap-stance-0", "0") -- caster
				frame:SetAttribute("statemap-stance-1", "1") -- bear
				frame:SetAttribute("statemap-stance-2", "0") -- aquatic
				frame:SetAttribute("statemap-stance-3", "3") -- cat
				frame:SetAttribute("statemap-stance-4", "0") -- travel
				frame:SetAttribute("statemap-stance-5", "5") -- moonkin/tree
				frame:SetAttribute("statemap-stance-6", "0") -- flying form
				frame:SetAttribute("statemap-stealth-1", "3:2") -- stealthed / prowl
				frame:SetAttribute("statemap-stealth-0", "2:3") -- unstealthed
				
				if form ~= 1 and form ~= 3 and form ~= 5 then form = 0
				elseif form == 3 and IsStealthed() then form = 2 end
			end
			frame:SetAttribute("state", tostring(form))
		end
		-- setup bar swapping support - only bar1
		if self.id == 1 then
			for i=1,6 do
				local state = 10+i
				frame:SetAttribute("statemap-actionbar-"..i, state)
				states1 = states1 .. state .. ":S" .. state .. "1;" 
				states2 = states2 .. state .. ":S" .. state .. "2;" 
			end
		end
		frame:SetAttribute("statebutton", states1)
		frame:SetAttribute("statebutton2", states2)
	end
	frame:EnableMouse(false)
	frame:SetMovable(true)
	frame:RegisterForDrag("LeftButton")
	frame:RegisterForClicks("RightButtonDown", "LeftButtonDown")
	frame:SetWidth(10)
	frame:SetHeight(10)
	frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16, edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16, insets = {left = 5, right = 3, top = 3, bottom = 5},})
	frame:SetBackdropColor(0, 0, 0, 0)
	frame:SetBackdropBorderColor(0.5, 0.5, 0, 0)
	frame:ClearAllPoints()
	frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	frame.Text = frame:CreateFontString(nil, "ARTWORK")
	frame.Text:SetFontObject(GameFontNormal)
	frame.Text:SetText()
	frame.Text:Show()
	frame.Text:ClearAllPoints()
	frame.Text:SetPoint("CENTER", frame, "CENTER",0,0)
	frame:SetPoint("CENTER")
	if self.config.Hide then frame:Hide() else frame:Show() end
	self.frame = frame
end

function Bartender3.Class.Bar.prototype:UnlockFrames()
	local frame = self.frame
	frame:EnableMouse(true)
	frame:SetScript("OnEnter", function() this:SetBackdropBorderColor(0.5, 0.5, 0, 1) end)
	frame:SetScript("OnLeave", function() this:SetBackdropBorderColor(0, 0, 0, 0) end)
	frame:SetScript("OnDragStart", function()
		this:StartMoving()
		this:SetBackdropBorderColor(0, 0, 0, 0)
	end)
	frame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SavePosition()
	end)
        frame:SetScript("OnClick", function(bself, button, down)
		if button == "RightButton" then
			self:ShowBarOptions()
		elseif button == "LeftButton" then
			self:ToggleVisibilty()
		end
	end)
	if self.config.Hide then
		frame:SetBackdropColor(1, 0, 0, 0.5)
	else
		frame:SetBackdropColor(0, 1, 0, 0.5)
	end
	frame:SetFrameLevel(3)
	frame.Text:SetText(self.barname)
	frame:Show()
	for i,v in pairs(self.buttons) do v:SetFrameLevel(2) end
end

function Bartender3.Class.Bar.prototype:LockFrames()
	local frame = self.frame
	frame:EnableMouse(false)
	frame:SetScript("OnEnter", nil)
	frame:SetScript("OnLeave", nil)
	frame:SetScript("OnDragStart", nil)
	frame:SetScript("OnDragStop", nil)
	frame:SetScript("OnClick", nil)
	frame:SetBackdropColor(0, 0, 0, 0)
	frame:SetBackdropBorderColor(0, 0, 0, 0)
	frame.Text:SetText("")
	frame:SetFrameLevel(1)
	if self.config.Hide then self.frame:Hide() else self.frame:Show() end
end

-- This function will not work in combat
function Bartender3.Class.Bar.prototype:ToggleVisibilty()
	if InCombatLockdown() then return end -- to avoid a message, you never know
	self.config.Hide = not self.config.Hide
	if self.config.Hide and Bartender3.unlock then
		self.frame:SetBackdropColor(1, 0, 0, 0.5)
	elseif self.config.Hide then
		self.frame:Hide()
	elseif Bartender3.unlock then
		self.frame:SetBackdropColor(0, 1, 0, 0.5)
	else
		self.frame:Show()
	end
end

function Bartender3.Class.Bar.prototype:RefreshLayout()
	if InCombatLockdown() then return end -- to avoid a message, you never know
	self:RefreshScale()
	self:RefreshButtonLayout()
	self:RefreshAlpha()
	if self.config.Hide and not Bartender3.unlock then self.frame:Hide() else self.frame:Show() end
end

function Bartender3.Class.Bar.prototype:LoadPosition()
	local x,y,s = self.config.PosX, self.config.PosY, self.frame:GetEffectiveScale()
	local defaultx, defaulty, defaultanchor = (Bartender3.defaultpositions[self.id].PosX) or 0, (Bartender3.defaultpositions[self.id].PosY) or 0, Bartender3.defaultpositions[self.id].Anchor or "BOTTOMLEFT"
	if x and y then
		x,y = x/s, y/s
	end
	self.frame:ClearAllPoints()
	self.frame:SetPoint("BOTTOMLEFT", UIParent, x and "BOTTOMLEFT" or defaultanchor, x or defaultx, y or defaulty)
end

function Bartender3.Class.Bar.prototype:SavePosition()
	local frame = self.frame
	local x,y = frame:GetLeft(), frame:GetBottom()
	local s = frame:GetEffectiveScale()
	x,y = x*s,y*s
	self.config.PosX = x
	self.config.PosY = y
end

function Bartender3.Class.Bar.prototype:RefreshButtonLayout()
	local Rows = self.config.Rows
	local ButtonPerRow = math.floor(#self.buttons / Rows) -- just a precaution
	local Padding = self.config.Padding
	self.frame:SetWidth(self.buttonwidth * ButtonPerRow + ((ButtonPerRow - 1) * Padding) + 8)
	self.frame:SetHeight(self.buttonheight * Rows + ((Rows - 1) * Padding) + 8)
	for i=1,#self.buttons do
		local button = self.buttons[i]
		button:ClearAllPoints()
		if i > 1 and ((i-1) % ButtonPerRow) == 0 then
			button:SetPoint("TOPLEFT", self.buttons[i-ButtonPerRow], "BOTTOMLEFT", 0, -Padding)
		elseif i > 1 then
			button:SetPoint("TOPLEFT", self.buttons[i-1], "TOPRIGHT", Padding, 0)
		else
			button:SetPoint("TOPLEFT", self.frame, "TOPLEFT", 5, -3)
		end
	end
end

function Bartender3.Class.Bar.prototype:RefreshStyle()
	local style = self.config.Style
	for i,v in pairs(self.buttons) do
		Bartender3:RefreshStyle(v, self)
	end
end

function Bartender3.Class.Bar.prototype:RefreshScale()
	self.frame:SetScale(self.config.Scale)
	self:LoadPosition()
end

function Bartender3.Class.Bar.prototype:RefreshAlpha()
	for i,v in pairs(self.buttons) do
		if (v.class and HasAction(v.class:PagedID())) or not v.class then v:SetAlpha(self.config.Alpha) end
	end
end

function Bartender3.Class.Bar.prototype:InitOptions()
	self.optionstable = Bartender3:CreateBarOptions(self.id, self.barname, not self.statebar)
	if self.optionstable.args.rows then self.optionstable.args.rows.max = ( #self.buttons > 1 ) and #self.buttons or 2 end
end

-- config functions

function Bartender3.Class.Bar.prototype:SetRows(r)
	local maxbuttons = #self.buttons
	self.config.Rows = maxbuttons /  math.floor(maxbuttons / r)
	self:RefreshButtonLayout()
end

function Bartender3.Class.Bar.prototype:SetPadding(r)
	self.config.Padding = r
	self:RefreshButtonLayout()
end

function Bartender3.Class.Bar.prototype:SetScale(s)
	self.config.Scale = s
	self:RefreshScale()
end

function Bartender3.Class.Bar.prototype:SetAlpha(a)
	self.config.Alpha = a
	self:RefreshAlpha()
end

function Bartender3.Class.Bar.prototype:SetStyle(s)
	self.config.Style = s
	self:RefreshStyle()
end

function Bartender3.Class.Bar.prototype:SetShowGrid(s)
	self.config.ShowGrid = s
	for i,v in pairs(self.buttonobjects) do
		local newalpha = 0
		if s then
			newalpha = self.config.Alpha / 2
		end
		if ( v.showgrid == 0 and not HasAction(v:PagedID()) ) then
			v.frame:SetAlpha(newalpha)
		end
	end
end

function Bartender3.Class.Bar.prototype:ShowBarOptions()
	if InCombatLockdown() then return end
	dewdrop:Open(self.frame, 'children', function() dewdrop:FeedAceOptionsTable(self.optionstable) end, 'cursorX', true, 'cursorY', true)
end

--[[
	Action Bars
	
	ActionBar is the abstract class for all of the 10 actionbars
	self.buttons holds the actual frames
	self.buttonobjects holds the ButtonClass objects
]]

function Bartender3.Class.ActionBar.prototype:init(id, config, numbuttons)
	Bartender3.Class.ActionBar.super.prototype.init(self, id, config, true)
	self.numbuttons = numbuttons
	self.buttonwidth = 36
	self.buttonheight = 36
	self:CreateButtons()
	
	self:InitOptions()
	
	self:RefreshLayout()
	self:RefreshStyle()
end

function Bartender3.Class.ActionBar.prototype:CreateButtons()
	if self.buttons or self.buttonobjects then return end
	self.buttons, self.buttonobjects, self.keybindings = {}, {}, {}
	for i=1, self.numbuttons do
		local button = Bartender3:GetFreeButton(self)
		table.insert(self.buttons, button.frame)
		table.insert(self.buttonobjects, button)
	end
end

function Bartender3.Class.Bar.prototype:SetButtons(a)
	local oldbuttons = self.numbuttons
	self.numbuttons = a
	self.config.Buttons = a
	if a > oldbuttons then
		for i=(oldbuttons+1),a do
			local button = Bartender3:GetFreeButton(self)
			table.insert(self.buttons, button.frame)
			table.insert(self.buttonobjects, button)
			if Bartender3.unlock then button.frame:SetFrameLevel(2) end
		end
	elseif a < oldbuttons then
		for i=(a+1), oldbuttons do
			-- fetch the last button
			local butnum = #self.buttonobjects
			-- release it
			self.buttonobjects[butnum]:ReleaseButton()
			-- and remove its keybindings option
			self.optionstable.args.keybindings.args["button"..butnum] = nil
			tremove(self.buttons)
			tremove(self.buttonobjects)
		end
	else return end -- no change
	local maxbuttons = #self.buttons
	self.optionstable.args.rows.max = ( maxbuttons > 1 ) and maxbuttons or 2
	-- refresh rows config.
	if self.config.Rows > maxbuttons then self:SetRows(maxbuttons) else self:SetRows(self.config.Rows) end
	self:RefreshLayout()
end

function Bartender3.Class.ActionBar.prototype:RefreshLayout()
	Bartender3.Class.ActionBar.super.prototype.RefreshLayout(self)
	if self.optionstable then self:RefreshKeyBindings() end
	self:UpdateSelfCast()
	self:RefreshStates()
	for i,v in pairs(self.buttonobjects) do
		v:UpdateButton()
	end
end

function Bartender3.Class.ActionBar.prototype:UpdateSelfCast(oldscm)
	local scm = Bartender3.db.profile.SelfCastModifier
	if oldscm and oldscm ~= "none" then
		self.frame:SetAttribute(oldscm.."-unit*", nil)
	end
	if scm ~= "none" then
		self.frame:SetAttribute(scm.."-unit*", "player")
	end
	
	local scrc = Bartender3.db.profile.SelfCastRightClick
	self.frame:SetAttribute("unit-S02", scrc and "player" or nil)
	if Bartender3.stanceinfo[Bartender3.playerclass] then
		for i,v in pairs(Bartender3.stanceinfo[Bartender3.playerclass]) do
			self.frame:SetAttribute("unit-S"..v.state.."2", scrc and "player" or nil)
		end
	end
end

function Bartender3.Class.ActionBar.prototype:RefreshKeyBindings()
	if not self.optionstable then return end
	local bindings = self.optionstable.args.keybindings.args
	for i=1, #self.buttons do
		if bindings["button"..i] == nil and self.buttons[i] ~= nil then -- button is new
			bindings["button"..i] = {
				type = "text",
				name = "Button "..i,
				desc = "Assign a Keybinding to Button "..i,
				validate = "keybinding",
				order = i,
				get = function()
					return Bartender3.db.profile.Keybindings[self.buttons[i]:GetName()]
				end,
				set = function(k)
					if k == nil then
						Bartender3:ClearBinding(self.buttons[i])
					else
						Bartender3:RegisterBinding(k, self.buttons[i])
					end
				end,
			}
		end
	end
end

function Bartender3.Class.ActionBar.prototype:RefreshStates()
	if InCombatLockdown() then return end
	for i,v in pairs(Bartender3.statemodifiers) do
		local page = self.config.States[v] or 0
		if page > 0 then
			self.frame:SetAttribute(v.."-statebutton*", "S"..v)
		else
			self.frame:SetAttribute(v.."-statebutton*", nil)
		end
	end
	for i,v in pairs(self.buttonobjects) do
		v:RefreshStateButtons()
	end
end

function Bartender3.Class.ActionBar.prototype:SetModifierState(modifier, page)
	if not self.config.States then return end
	self.config.States[modifier] = page
	self:RefreshStates()
end

function Bartender3.Class.ActionBar.prototype:SetStancePage(stance, page)
	self.config.Stances[stance] = page
	self:RefreshStates()
end

--[[
	Special Bars
	
	Special Bars are an abstraction layer for the MicroMenu/Bags/Stance/Pet Bar
	The table self.buttons holds the actual frames of the buttons.
]]

function Bartender3.Class.SpecialBar.prototype:init(bartype, barname, config)
	Bartender3.Class.SpecialBar.super.prototype.init(self, bartype, config, false)
	self.bartype = bartype
	self.barname = barname
	self:AssignFrames(bartype)
	
	self:InitOptions()
	
	self:RefreshLayout()
	self:RefreshStyle()
end

function Bartender3.Class.SpecialBar.prototype:AssignFrames(bartype)
	if self.buttons then return end
	self.buttons = {}
	if not bartype then bartype = self.bartype end
	if ( bartype == "STANCE" ) then
		self.buttonwidth = ShapeshiftButton1:GetWidth()
		self.buttonheight = ShapeshiftButton1:GetHeight()
		for i=1,10 do 
			local button = getglobal("ShapeshiftButton"..i)
			button:SetParent(self.frame)
			button:SetNormalTexture("")
			
			button.icon = getglobal("ShapeshiftButton"..i.."Icon")
			
			table.insert(self.buttons, button) 
		end
	elseif ( bartype == "PET" ) then
		self.buttonwidth = PetActionButton1:GetWidth()
		self.buttonheight = PetActionButton1:GetHeight()
		for i=1,10 do 
			local button = getglobal("PetActionButton"..i)
			button:SetParent(self.frame)
			button:SetNormalTexture("")
			
			button.icon = getglobal("PetActionButton"..i.."Icon")
			
			table.insert(self.buttons, button) 
		end
	elseif ( bartype == "MICROMENU" ) then
		self.buttonwidth = CharacterMicroButton:GetWidth()
		self.buttonheight = CharacterMicroButton:GetHeight()
		table.insert(self.buttons, CharacterMicroButton)
		table.insert(self.buttons, SpellbookMicroButton)
		table.insert(self.buttons, TalentMicroButton)
		table.insert(self.buttons, QuestLogMicroButton)
		table.insert(self.buttons, SocialsMicroButton)
		table.insert(self.buttons, LFGMicroButton)
		table.insert(self.buttons, MainMenuMicroButton)
		table.insert(self.buttons, HelpMicroButton)
		
		for i,v in pairs(self.buttons) do v:SetParent(self.frame); v:Show(); end
	elseif ( bartype == "BAGS" ) then
		self.buttonwidth = MainMenuBarBackpackButton:GetWidth()
		self.buttonheight = MainMenuBarBackpackButton:GetHeight()
		
		if self.config.Keyring then
			table.insert(self.buttons, KeyRingButton)
		else
			KeyRingButton:Hide()
		end
		
		if not self.config.OneBag then
			table.insert(self.buttons, CharacterBag3Slot) 
			table.insert(self.buttons, CharacterBag2Slot) 
			table.insert(self.buttons, CharacterBag1Slot) 
			table.insert(self.buttons, CharacterBag0Slot)
		else
			CharacterBag3Slot:Hide()
			CharacterBag2Slot:Hide()
			CharacterBag1Slot:Hide()
			CharacterBag0Slot:Hide()
		end
	 	MainMenuBarBackpackButton:SetScript("OnClick", function() OpenAllBags() end)
		table.insert(self.buttons, MainMenuBarBackpackButton)
		for i,v in pairs(self.buttons) do 
			v.icon = getglobal(v:GetName().."IconTexture")
			v:SetParent(self.frame)
			if v ~= KeyRingButton then v:SetNormalTexture("") end
			v:Show()
		end
	end
end

function Bartender3.Class.SpecialBar.prototype:ToggleKeyring()
	if self.bartype ~= "BAGS" then return end
	self.config.Keyring = not self.config.Keyring
	self.buttons = nil
	self:AssignFrames(self.bartype)
	self:RefreshLayout()
	self:RefreshStyle()
end

function Bartender3.Class.SpecialBar.prototype:ToggleOneBag()
	if self.bartype ~= "BAGS" then return end
	self.config.OneBag = not self.config.OneBag
	self.buttons = nil
	self:AssignFrames(self.bartype)
	self:RefreshLayout()
	self:RefreshStyle()
	self.optionstable.args.rows.max = ( #self.buttons > 1 ) and #self.buttons or 2
end
