
local BT3DLPadding = 3

function Bartender3:RefreshStyle(button, bar)
	if not button.icon then return end
	local style = bar.config.Style
	if style == "Zoomed" or style == "Dreamlayout" then
		-- zoom the texture
		button.icon:SetTexCoord(0.07,0.93,0.07,0.93)
	else -- default
		-- restore zoom
		button.icon:SetTexCoord(0,1,0,1)
	end
	-- dreamlayout
	if style == "Dreamlayout" then
		if not button.dreamlayout then
			button.dreamlayout = self:Dreamlayout_CreateBG(button)
		end
		button.icon:ClearAllPoints()
		button.icon:SetPoint("TOPLEFT", button.dreamlayout, "TOPLEFT", BT3DLPadding, -BT3DLPadding)
		button.icon:SetPoint("BOTTOMRIGHT", button.dreamlayout, "BOTTOMRIGHT",  -BT3DLPadding, BT3DLPadding)
		if button.class and not HasAction(button.class:PagedID()) then button.dreamlayout:Hide() 
		else button.dreamlayout:Show() end
	else
		-- hide the dreamlayout frame
		if button.dreamlayout then
			button.dreamlayout:Hide()
			button.icon:ClearAllPoints()
			button.icon:SetAllPoints(button)
		end
	end
end

function Bartender3:Dreamlayout_CreateBG(button)
	local frame = CreateFrame("Frame", button:GetName().."DL", button)
	frame:ClearAllPoints()
	frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 1, edgeFile = "", edgeSize = 0, insets = {left = 0, right = 0, top = 0, bottom = 0},})
	frame:SetBackdropColor(0, 0, 0, 0.6)
	frame:SetPoint("TOPLEFT", button, "TOPLEFT", 0, 0)
	frame:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", 0, -0)
	frame:SetFrameLevel(0)
	return frame
end
