local Tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_LootTypeFu")
local Dewdrop = AceLibrary("Dewdrop-2.0")

LootTypeFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

LootTypeFu:RegisterDB("LootTypeFuDB")
LootTypeFu:RegisterDefaults('profile', 
	{
	}
)

LootTypeFu.version = "1.0." .. string.sub("$Revision: 9785 $", 12, -3)
LootTypeFu.date = string.sub("$Date: 2006-09-02 10:55:39 +0930 (Sat, 02 Sep 2006) $", 8, 17)
LootTypeFu.hasIcon = "Interface\\AddOns\\FuBar_LootTypeFu\\LootType.tga"
LootTypeFu.defaultPosition = 'LEFT'
LootTypeFu.hideWithoutStandby = true
LootTypeFu.independentProfile = true

LootTypeFu.OnMenuRequest = 
{
	handler = LootTypeFu,
	type = 'group',
	args = 
	{
	},
}


function LootTypeFu:OnInitialize()
end

function LootTypeFu:OnEnable()
    self:RegisterEvent("PARTY_MEMBERS_CHANGED", "UpdateDisplay")
    self:RegisterEvent("RAID_ROSTER_UPDATE", "UpdateDisplay")
    self:RegisterEvent("PARTY_LOOT_METHOD_CHANGED", "UpdateDisplay")
end

function LootTypeFu:OnDisable()
end

function LootTypeFu:OnTextUpdate()
	if (GetNumPartyMembers() > 0) or (GetNumRaidMembers() > 0) then
		local lootTypeText = L[GetLootMethod()]
		local color = ITEM_QUALITY_COLORS[GetLootThreshold()].hex

		self:SetText(color..lootTypeText)
	else
		self:SetText(L["Inactive"])
	end
end

function LootTypeFu:OnTooltipUpdate()
end

function LootTypeFu:OnClick()
	if ((GetNumPartyMembers() > 0) or (GetNumRaidMembers() > 0)) and IsPartyLeader() then
	end
end
