<?php
/******************************
 * EQdkp CT_RaidTracker Import
 * Copyright 2005
 * Licensed under the GNU GPL.  See COPYING for full terms.
 * ------------------
 * config.php
 ******************************/
define('EQDKP_INC', true);
$eqdkp_root_path = './../../';
include_once($eqdkp_root_path . 'common.php');
include_once($eqdkp_root_path . 'itemstats/eqdkp_itemstats.php');

if (!$pm->check(PLUGIN_INSTALLED, 'raidbanker')) { message_die('The Raid Banker plugin is not installed.'); }
global $table_prefix;

if (!defined('RB_BANK_TABLE')) { define('RB_BANK_TABLE', $table_prefix . 'raidbanker_bank'); }
if (!defined('RB_CHARS_TABLE')) { define('RB_CHARS_TABLE', $table_prefix . 'raidbanker_chars'); }

$pm->get_data('raidbanker', 'template_path');

$sql = "SELECT rb_char_name, rb_char_gold, rb_char_silver, rb_char_copper from ".RB_CHARS_TABLE." ORDER BY rb_char_name";

if ( !($chars_result = $db->query($sql)) )
{
    message_die('Could not obtain charcaters information', '', __FILE__, __LINE__, $sql);
}

$item_stats = new ItemStats();

if ($_GET["refresh"]!= "")
{
	$item_stats->updateItem(urlencode(urldecode($_GET["refresh"])));
}

while ( $char = $db->fetch_record($chars_result) )
{
    $tpl->assign_block_vars('chars_row', array(
        'ROW_CLASS' => $eqdkp->switch_row_class(),
        'NAME' => $char['rb_char_name'],
        'GOLD' => $char['rb_char_gold'],
        'SILVER' => $char["rb_char_silver"],
        'COPPER' => $char["rb_char_copper"]
        )
    );
}
$db->free_result($chars_result);


$sql = "SELECT sum(rb_item_amount) as qty, rb_item_name, rb_item_type, rb_char_name FROM ".RB_BANK_TABLE." GROUP BY rb_item_name, rb_item_type, rb_char_name ORDER BY rb_item_rarity DESC, rb_item_name ASC, rb_char_name ASC";
if ( !($items_result = $db->query($sql)) )
{
    message_die('Could not obtain items information', '', __FILE__, __LINE__, $sql);
}


while ( $item = $db->fetch_record($items_result) )
{
	$link = $item_stats->getItemLink(stripslashes($item['rb_item_name']));
	$name = $item_stats->getItemName(urldecode(urlencode($item['rb_item_name'])),true);
	$target = "target=\"_blank\"";
	if (trim($link) == "")
	{
		$link = "raidbanker.php" . $SID . "&amp;". "refresh=" . $name;
		$target = "";
	}

    $tpl->assign_block_vars('items_row', array(
        'ROW_CLASS' => $eqdkp->switch_row_class(),
        'QTY' => $item['qty'],
        'NAME' => itemstats_decorate_name($name),
        'LINK' => $link,
        'TYPE' => $item["rb_item_type"],
        'BANKER' => $item["rb_char_name"],
        'TARGET' => $target
        )
    );
}
$db->free_result($items_result);

$eqdkp->set_vars(array(
	'page_title'        => sprintf($user->lang['admin_title_prefix'], $eqdkp->config['guildtag'], $eqdkp->config['dkp_name']).': '.$user->lang['rb_step1_pagetitle'],
	'template_path' 	=> $pm->get_data('raidbanker', 'template_path'),
	'template_file'     => 'bank.html',
	'display'           => true,
	)
);
?>