<?php
/******************************
 * EQdkp CT_RaidTracker Import
 * Copyright 2005
 * Licensed under the GNU GPL.  See COPYING for full terms.
 * ------------------
 * config.php
 ******************************/

// EQdkp required files/vars
define('EQDKP_INC', true);
define('PLUGIN', 'raidbanker');

$eqdkp_root_path = './../../../';
include_once($eqdkp_root_path . 'common.php');
include_once($eqdkp_root_path . 'itemstats/eqdkp_itemstats.php');

if (!defined('RB_BANK_TABLE')) { define('RB_BANK_TABLE', $table_prefix . 'raidbanker_bank'); }
if (!defined('RB_CHARS_TABLE')) { define('RB_CHARS_TABLE', $table_prefix . 'raidbanker_chars'); }


$rb = $pm->get_plugin('raidbanker');

if ( !$pm->check(PLUGIN_INSTALLED, 'raidbanker') )
{
    message_die('The Raid Banker plugin is not installed.');
}

class RaidBanker_Import extends EQdkp_Admin
{


    function RaidBanker_Import()
    {
        global $db, $eqdkp, $user, $tpl, $pm;
        global $SID;

        parent::eqdkp_admin();

        $this->assoc_buttons(
        	array(
				'parse' => array('name' => 'doParse','process' => 'process_parse','check'   => 'a_raidbanker_import'),
				'insert' => array('name' => 'doInsert','process' => 'process_insert','check'   => 'a_raidbanker_import'),
				'form' => array('name' => '','process' => 'display_form', 'check' => 'a_raidbanker_import')
        	));
    }


	function process_parse()
	{
		global $db, $eqdkp, $user, $tpl, $pm;
		global $SID;

		$log = trim($_POST['log']);

		$items = split("\n", $log);
		$num = 0;
		$charName = "";
		$charGold = 0;
		$charSilver = 0;
		$charCopper = 0;
		foreach($items as $row)
		{
			$item = split("/", $row);
			if ($num == 0)
			{
				$charName = $item[0];
				$charGold = substr($item[1], 0, strlen($item[1])-4);
				$charSilver = substr($item[1], -2, 2);
				$charCopper = substr($item[1], -4, 2);
			}
			else
			{
				$tpl->assign_block_vars(
					'items_row',
					array(
						'NAME' => stripslashes($item[0]),
						'AMOUNT' => $item[1],
						'QUALITY' => $item[2],
						'TYPE' => $item[3],
						'ROW_CLASS' => $eqdkp->switch_row_class(),
						'NUMBER' => $num
					)
				);
			}
			$num++;
		}

		$tpl->assign_vars(array(
		            'S_STEP1'		=> false,
		            'L_CHARNAME'	=> $charName,
		            'L_CHARGOLD'	=> $charGold,
		            'L_CHARSILVER'	=> $charSilver,
		            'L_CHARCOPPER'	=> $charCopper,
		            'L_BANK_INSERT'	=> "Update Bank Data",
		            'L_FOUND_ITEMS'	=> "Items found in log"
		            )
        );

        $eqdkp->set_vars(array(
			'page_title'        => sprintf($user->lang['admin_title_prefix'], $eqdkp->config['guildtag'], $eqdkp->config['dkp_name']).': '.$user->lang['rb_step2_pagetitel'],
			'template_path' 	=> $pm->get_data('raidbanker', 'template_path'),
			'template_file'     => 'import.html',
			'display'           => true,
			)
        );
    }

	function process_insert()
	{

		global $db, $eqdkp, $user, $tpl, $pm;
		global $SID;

		$charName = $_POST["charName"];

		$db->query("DELETE FROM ".RB_CHARS_TABLE." WHERE rb_char_name = '".mysql_escape_string($_POST["charName"])."'");
		$db->query("DELETE FROM ".RB_BANK_TABLE." WHERE rb_char_name = '".mysql_escape_string($_POST["charName"])."'");
		$tpl->assign_block_vars(
			'logs_row',
			array(
				'DES' => "cleared all data for $charName",
				'ROW_CLASS' => $eqdkp->switch_row_class()
			)
		);


		$db->query("INSERT INTO ".RB_CHARS_TABLE." (rb_char_name, rb_char_gold, rb_char_silver, rb_char_copper) VALUES('".mysql_escape_string($_POST["charName"])."',".$_POST["charGold"].",".$_POST["charSilver"].",".$_POST["charSilver"].")");
		$tpl->assign_block_vars(
			'logs_row',
			array(
				'DES' => "added char data for $charName",
				'ROW_CLASS' => $eqdkp->switch_row_class()
			)
		);

		$item_stats = new ItemStats();

		foreach($_POST["item"] as $item)
		{
			if(!isset($item["skip"]))
			{
				$sql  = "INSERT INTO ".RB_BANK_TABLE." (rb_char_name, rb_item_name, rb_item_rarity, rb_item_type, rb_item_amount) VALUES ";
				$sql .= "(\"".$_POST["charName"]."\",";
				$sql .= "\"".$item_stats->getItemName(stripslashes($item["name"]),false)."\",";
				$sql .= "".$item["quality"].",";
				$sql .= "'".$item["type"]."',";
				$sql .= "".$item["amount"].")";


				$db->query($sql);
				$tpl->assign_block_vars(
					'logs_row',
					array(
						'DES' => "adding item ".stripslashes($item["name"]),
						'ROW_CLASS' => $eqdkp->switch_row_class()
					)
				);
			}
			else
			{
				$tpl->assign_block_vars(
					'logs_row',
					array(
						'DES' => "<b>skippeed</b> item ".$item["name"],
						'ROW_CLASS' => $eqdkp->switch_row_class()
					)
				);
			}
		}



		$eqdkp->set_vars(array(
			'page_title'        => sprintf($user->lang['admin_title_prefix'], $eqdkp->config['guildtag'], $eqdkp->config['dkp_name']).': '.$user->lang['rb_step2_pagetitel'],
			'template_path' 	=> $pm->get_data('raidbanker', 'template_path'),
			'template_file'     => 'import_result.html',
			'display'           => true,
			)
		);


	}

	function display_form()
	{
		global $db, $eqdkp, $user, $tpl, $pm;
		global $SID;

		$tpl->assign_vars(array(
			'F_PARSE_LOG'    => 'importbankdata.php' . $SID,
			'S_STEP1'        => true,
			'L_PASTE_LOG'    => $user->lang['rb_step1_th'],
			'L_PARSE_LOG'    => $user->lang['rb_step1_button_parselog'],
			)
		);

		$eqdkp->set_vars(array(
			'page_title'        => sprintf($user->lang['admin_title_prefix'], $eqdkp->config['guildtag'], $eqdkp->config['dkp_name']).': '.$user->lang['rb_step1_pagetitle'],
			'template_path' 	=> $pm->get_data('raidbanker', 'template_path'),
			'template_file'     => 'import.html',
			'display'           => true,
			)
		);
	}
}

$RB_Import = new RaidBanker_Import();
$RB_Import->process();
?>