<?php
if ( !defined('EQDKP_INC') )
{
    die('You cannot access this file directly.');
}

global $table_prefix;
if (!defined('RB_BANK_TABLE')) { define('RP_BANK_TABLE', $table_prefix . 'raidbanker_bank'); }
if (!defined('RB_CHARS_TABLE')) { define('RP_CHARS_TABLE', $table_prefix . 'raidbanker_chars'); }

class raidbanker_Plugin_Class extends EQdkp_Plugin
{
    function raidbanker_plugin_class($pm)
    {
        global $eqdkp_root_path, $user, $SID, $table_prefix;;

        // Call our parent's constructor
        $this->eqdkp_plugin($pm);


        // Get language pack
        $this->pm->get_language_pack('raidbanker');

        // Data for this plugin
		$this->add_data(array(
			'name'			=> 'Raid Banker',
			'code'			=> 'raidbanker',
			'path'			=> 'raidbanker',
			'contact'		=> 'fray.asamith@hotmail.com',
			'template_path'	=> 'plugins/raidbanker/templates/',
			'version'		=> '0.1RC1')
        );

        // Register our permissions
        $this->add_permission('901', 'a_raidbanker_import',    'N', $user->lang['rb_import']);

        // Add Menus
		$this->add_menu('main_menu1', $this->gen_main_menu1());
		$this->add_menu('admin_menu', $this->gen_admin_menu());


        // Define installation
        // -----------------------------------------------------
        $sql = "CREATE TABLE IF NOT EXISTS " . $table_prefix . "raidbanker_bank (
				rb_bank_id mediumint(8) unsigned NOT NULL auto_increment,
				rb_char_name varchar(255) default NULL,
				rb_item_name varchar(255) default NULL,
				rb_item_rarity mediumint(8) default 0,
				rb_item_type varchar(255) default NULL,
				rb_item_amount mediumint(8) default 0,
				PRIMARY KEY  (rb_bank_id)
		) ";
		$this->add_sql(SQL_INSTALL, $sql);
		$this->add_sql(SQL_UNINSTALL, "DROP TABLE IF EXISTS " . $table_prefix . "raidbanker_bank");

		$sql = "CREATE TABLE IF NOT EXISTS " . $table_prefix . "raidbanker_chars (
						rb_char_name varchar(255) default NULL,
						rb_char_gold mediumint(8) default 0,
						rb_char_silver mediumint(8) default 0,
						rb_char_copper mediumint(8) default 0,
						PRIMARY KEY  (rb_char_name)
				) ";
				$this->add_sql(SQL_INSTALL, $sql);
		$this->add_sql(SQL_UNINSTALL, "DROP TABLE IF EXISTS " . $table_prefix . "raidbanker_chars");

        // Define uninstallation
        // -----------------------------------------------------
        // Nothing special to do
    }

    function gen_main_menu1()
	    {
			global $user, $SID;

	        if ($this->pm->check(PLUGIN_INSTALLED, 'raidbanker'))
	        {
	            global $db, $user;

	            $main_menu1 = array(
	                array(
						'link' => 'plugins/' . $this->get_data('path') . '/raidbanker.php' . $SID,
						'text' => $user->lang['rb_usermenu_raidbanker'],
						'check' => ''
					)
	            );

	            return $main_menu1;
	        }
	        return;
    }

    function gen_admin_menu()
    {
        if ( $this->pm->check(PLUGIN_INSTALLED, 'raidbanker') )
        {
            global $db, $user, $SID;

            $admin_menu = array(
				'raidbanker' => array(
					0 => $user->lang['rb_adminmenu_raidbanker'],
					1 => array(
						'link' => '../plugins/'.$this->get_data('path').'/admin/importbankdata.php' . $SID,
						'text' => $user->lang['rb_import'],
						'check' => 'a_raidbanker_import')
				)
			);

            return $admin_menu;
        }
        return;
    }

}
?>