--[[
RaidBanker v 0.1

Addon that create a string parasble by Raid Banker plugin in EQDKP

Author: Fray, Asamith, Runetotem
Date: 07/11/2005

]]--
---------------------------------------------------------------
----------------------Standart mesages-------------------------
---------------------------------------------------------------

local RB_VER    = "0.1";

local MSG_RB_GREETING1 = "RaidBanker v" .. RB_VER .. " is loaded.";
local MSG_RB_GREETING2 = "For more information type /rb info.";
local MSG_RB_GREETING = "RaidBanker v" .. RB_VER .. ".";

---------------------------------------------------------------
----------------Global RaidBanker variables--------------------
---------------------------------------------------------------

--BankOpen indicator
-- 0 - bank closed
-- 1 - bank opened
local BankStatus = 0;
--Position in the array GT_Saved of the current character 
-- -1 - not in array
local Position=-1;
--Debug mode indicator 
-- 1 - debug mode on
-- 0 - debug mode off (default)
local DebugMode = 0;
--List of the bags to look in
local BanknBags = { -1, 5, 6, 7, 8, 9, 10, 0, 1, 2, 3, 4};
local MoneyScanned = 1;

local RBString = "";


--OnEvent function
function RB_OnEvent()	 
	RB_Debug("OnEvent is called");

	if (event == "VARIABLES_LOADED") then
		RB_Debug("Variables are loaded.");
		SlashCmdList["RAIDBANKER"] = RB_SlashCommand;
		SLASH_RAIDBANKER1 = "/raidbanker";
		SLASH_RAIDBANKER2 = "/rb";				
		
		RB_Debug("Position: "..Position);
		RB_Echo(MSG_RB_GREETING1);
		RB_Echo(MSG_RB_GREETING2);				
		
	elseif (event == "BANKFRAME_OPENED") then
		RB_Debug("Bank was opened.");
		BankStatus = 1;

	elseif (event == "BANKFRAME_CLOSED") then
		RB_Debug("Bank was closed.");		
		BankStatus = 0;	
	end
end

function RB_SlashCommand(msg)
	msg = string.lower(msg);
	RB_Debug("/command: "..msg);	
		
	if (msg == "debug") then		
		if (DebugMode == 1) then			
			DebugMode = 0;
		else			
			DebugMode = 1;
		end								
		
	elseif (msg == "scan") then		
		NumItems = 1;
		if (BankStatus == 1) then			
			RB_Debug("RB_DoScan is called.");
			RB_DoScan();
			RB_Debug("RB_DoScan exited.");			
			RB_Echo("RaidBanker scan completed!Use </rb getlog> to get the log to parse.");
		else
			RB_Echo("Bak is closed. Can't continue with operation!");
		end				
	elseif (msg == "getlog") then		
		RB_DoGetLog();
	end
end

function RB_GetItemInfo(bag_id, slot_id)
	local count, texture, itemLink, itemName, i, command, itemQuality, itemDesc, itemType, itemSubType;
	
	if (not GetContainerItemInfo(bag_id, slot_id)) then 
		RB_Debug("No item in the slot "..bag_id..", "..slot_id);
		return nil;
	end
	
	--Get texture and count of the item in the current slot
	texture, count = GetContainerItemInfo(bag_id, slot_id);
	_,_,texture = string.find(texture, "%a+\\%a+\\([%w_]+)");
	
	--Get link and the name of the item in the current slot
	itemLink = GetContainerItemLink(bag_id, slot_id);
	_, _, itemLink, itemName = string.find(itemLink,
	"|H(item:%d+:%d+:%d+:%d+)|h%[([^]]+)%]|h|r$");
	_, _, itemQuality, _, itemType, itemSubType = GetItemInfo(itemLink);		
		
	return itemName, itemQuality, itemDesc, count, texture, itemType, itemSubType;
end

function RB_Echo(message)
	if ( DEFAULT_CHAT_FRAME ) then 
		DEFAULT_CHAT_FRAME:AddMessage(message, 0.5, 0.5, 1.0);
	end
end

function RB_Debug(message)
	if (DebugMode == 1) then
		message = "RB><**Debug**> " .. message;
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(message, 1.0, 0.0, 0.0);
		end
	end
end


function RB_DoScan()		
	local index, bag_id, slot_id, count, texture, itemLink, itemName, i, command, itemQuality, itemDesc, itemType, itemSubType;
	RBString = UnitName("player").."/"..GetMoney().."/-1/gold/\n";
	--Go through every slot in the bags (and bank)
	for index, bag_id in BanknBags do
		if (GetContainerNumSlots(bag_id)) then
			for slot_id = 1, GetContainerNumSlots(bag_id), 1 do
				if (GetContainerItemLink(bag_id, slot_id)) then
					
					itemName, itemQuality, itemDesc, count, texture, itemType, itemSubType = RB_GetItemInfo(bag_id, slot_id);
										
					RBString = RBString ..itemName.."/";
					RBString = RBString ..count.."/";
					RBString = RBString ..itemQuality.."/";
					RBString = RBString ..itemType.."/\n";
				end
			end
		end
	end		
end

function RB_DoGetLog()
	URLFrameEditBox:SetText(RBString);
	URLFrameEditBox:HighlightText();
	URLFrame:Show();
end